/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.custinfo;

import com.ibm.hwmca.base.custinfo.CustomerInfoConstants;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoEvent;
import com.ibm.hwmca.base.custinfo.CustomerInfoListener;
import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CustomerInfoManager
implements CustomerInfoConstants {
    private static final String TRACE_MASKT = "XCINMGRT";
    private static final String TRACE_MASKF = "XCINMGRF";
    private static final String TRACE_MASKD = "XCINMGRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "CustInfo-Mgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.base.custinfo.CustomerInfoData";
    private static CustomerInfoManager custInfoMgr = null;
    private Object dataLock = new Object();
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();

    private CustomerInfoManager() {
        Trace.trace(TRACE_MASKT, "<> CustomerInfoManager()");
    }

    public static synchronized CustomerInfoManager getCustomerInfoManager() {
        Trace.trace(TRACE_MASKT, "-> getCustomerInfoManager()");
        if (custInfoMgr == null) {
            custInfoMgr = new CustomerInfoManager();
        }
        Trace.trace(TRACE_MASKT, "<- getCustomerInfoManager()");
        return custInfoMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomerInfoListener(CustomerInfoListener listener) {
        if (listener != null) {
            Trace.trace(TRACE_MASKT, "-> addCustomerInfoListener(" + listener.getClass().getName() + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> addCustomerInfoListener(null)");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- addCustomerInfoListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomerInfoListener(CustomerInfoListener listener) {
        if (listener != null) {
            Trace.trace(TRACE_MASKT, "-> removeCustomerInfoListener(" + listener.getClass().getName() + ")");
        } else {
            Trace.trace(TRACE_MASKT, "-> removeCustomerInfoListener(null)");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeCustomerInfoListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerInfoData getCustomerInfo() {
        Trace.trace(TRACE_MASKT, "-> getCustomerInfo()");
        CustomerInfoData custInfoData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    custInfoData = (CustomerInfoData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 2066, pe).log();
                    custInfoData = new CustomerInfoData();
                }
            } else {
                custInfoData = new CustomerInfoData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getCustomerInfo()");
        return custInfoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomerInfo(CustomerInfoData data) {
        DataRepApp dataRepApp;
        Trace.trace(TRACE_MASKT, "-> setCustomerInfo()");
        Trace.trace(TRACE_MASKF, data.toString());
        Date origLastUpdated = data.getLastUpdated();
        boolean replicateData = false;
        Object object = this.dataLock;
        synchronized (object) {
            try {
                data.setLastUpdated(new Date());
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
                Object object2 = this.listenersLock;
                synchronized (object2) {
                    if (this.listeners.size() > 0) {
                        CustomerInfoData dataCopy = this.getCustomerInfo();
                        CustomerInfoEvent event = new CustomerInfoEvent(this, 1, dataCopy);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            CustomerInfoListener listener = (CustomerInfoListener)iterator.next();
                            String className = listener.getClass().getName();
                            Trace.trace(TRACE_MASKF, "-> " + className + ".customerInfoChanged()");
                            listener.customerInfoChanged(event);
                            Trace.trace(TRACE_MASKF, "<- " + className + ".customerInfoChanged()");
                        }
                    }
                }
                replicateData = true;
            }
            catch (PersistenceException pe) {
                new FrameworkLog(classLogInfo, 2066, pe).log();
                data.setLastUpdated(origLastUpdated);
            }
        }
        if (replicateData && (dataRepApp = DataRepApp.getDataRepApp()).isDataRepEnabled() && !dataRepApp.isUpdateInProgress()) {
            dataRepApp.updateCustomDataLevel(PERSISTENCE_NAME);
        }
        Trace.trace(TRACE_MASKT, "<- setCustomerInfo()");
    }

    public static class SaveRestore
    implements CustomizableData {
        public UIInfo getUIInfo() {
            LocalizableText name = new LocalizableText("com.ibm.hwmca.base.custinfo.res.CustomerInfoMsgs", "DATA_NAME");
            LocalizableText caption = new LocalizableText("com.ibm.hwmca.base.custinfo.res.CustomerInfoMsgs", "DATA_CAPTION");
            return new UIInfo(name, caption);
        }

        public Serializable getSaveableData() {
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "-> getSaveableData()");
            CustomerInfoManager infoMgr = CustomerInfoManager.getCustomerInfoManager();
            CustomerInfoData custInfoData = infoMgr.getCustomerInfo();
            Trace.trace(CustomerInfoManager.TRACE_MASKF, custInfoData.toString());
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<- getSaveableData()");
            return custInfoData.getPersistentData();
        }

        public void restoreData(Serializable obj) {
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "-> restoreData()");
            try {
                PersistentData persistentData = (PersistentData)obj;
                CustomerInfoData custInfoData = new CustomerInfoData(persistentData);
                CustomerInfoManager infoMgr = CustomerInfoManager.getCustomerInfoManager();
                infoMgr.setCustomerInfo(custInfoData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(CustomerInfoManager.TRACE_MASKT, "<- restoreData()");
        }

        public String getCustomDataKey() {
            return CustomerInfoManager.PERSISTENCE_NAME;
        }
    }
}

